#!/usr/bin/env python3
from __future__ import annotations

import argparse
import os
import sys

SCRIPT_DIR = os.path.dirname(__file__)
REPO_ROOT = os.path.abspath(os.path.join(SCRIPT_DIR, os.pardir, os.pardir))

if REPO_ROOT not in sys.path:
    sys.path.insert(0, REPO_ROOT)

from cothinker.baselines.registry import get_config
from cothinker.scripts.run_livebench_adapter import main as adapter_main


def main():
    parser = argparse.ArgumentParser(description="Run a predefined baseline by name")
    parser.add_argument("--baseline", type=str, required=True, help="io|cot|sr|mad|dmad|sw_mas")
    # pass-through args to adapter
    args, unknown = parser.parse_known_args()

    # Inject config overrides via env for adapter to read, or simply instruct user to pass flags.
    # Simplest: print recommended flags, then call adapter with them appended to argv.
    cfg = get_config(args.baseline)
    extra = [
        f"--num-agents", str(cfg.num_agents),
        f"--num-rounds", str(cfg.num_rounds),
        f"--max-tokens-turn", str(cfg.max_tokens_turn),
        f"--max-tokens-summarize", str(cfg.max_tokens_summarize),
        f"--max-tokens-synth", str(cfg.max_tokens_synth),
        f"--summarizer", cfg.summarizer,
    ]
    if cfg.enable_style_generator:
        extra.append("--enable-style-generator")

    sys.argv = [sys.argv[0]] + unknown + extra
    adapter_main()


if __name__ == "__main__":
    main()
